<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';

if (empty($_SESSION['admin'])){
    header('Location: login.php');
    exit;
}

if (!isset($_POST['name']) || !isset($_POST['category_id'])){
    header('Location: products.php');
    exit;
}

$data = load_data();

$name         = trim($_POST['name']);
$desc         = trim($_POST['description'] ?? '');
$category_id  = (int)$_POST['category_id'];
$price        = isset($_POST['price']) ? (int)$_POST['price'] : 0;
$link         = trim($_POST['link'] ?? '');
$stock        = isset($_POST['stock']) ? (int)$_POST['stock'] : 0;
$id           = isset($_POST['id']) && $_POST['id'] !== '' ? (int)$_POST['id'] : null;

$video_path   = null;

/* ------------------------------
   UPLOAD MULTIPLE IMAGES
--------------------------------*/
$uploadedImages = [];

if (isset($_FILES['images']) && isset($_FILES['images']['name'][0])) {

    for ($i = 0; $i < count($_FILES['images']['name']); $i++) {

        if ($_FILES['images']['error'][$i] == UPLOAD_ERR_OK) {

            $file = [
                'name'     => $_FILES['images']['name'][$i],
                'type'     => $_FILES['images']['type'][$i],
                'tmp_name' => $_FILES['images']['tmp_name'][$i],
                'error'    => $_FILES['images']['error'][$i],
                'size'     => $_FILES['images']['size'][$i]
            ];

            $uploaded = upload_media($file);
            if ($uploaded) {
                $uploadedImages[] = $uploaded;
            }
        }
    }
}

/* ------------------------------
   UPLOAD VIDEO (single)
--------------------------------*/
if (isset($_FILES['video']) && $_FILES['video']['error'] == UPLOAD_ERR_OK){
    $uploaded = upload_media($_FILES['video']);
    if ($uploaded) $video_path = $uploaded;
}

/* =====================================================
   UPDATE EXISTING PRODUCT
===================================================== */
if ($id){

    foreach($data['products'] as &$p) if ($p['id'] == $id){

        $p['name']        = $name;
        $p['description'] = $desc;
        $p['category_id'] = $category_id;
        $p['price']       = $price;
        $p['link']        = $link;
        $p['stock']       = $stock;

        /* ------------------------------
           HANDLE IMAGES
        --------------------------------*/

        // Produk lama masih pakai field 'image'? Konversi ke array.
        if (!isset($p['images'])) {
            $p['images'] = [];
            if (!empty($p['image'])) {   
                $p['images'][] = $p['image'];
            }
            unset($p['image']);
        }

        // Tambahkan gambar baru bila ada
        if (!empty($uploadedImages)) {
            foreach ($uploadedImages as $img) {
                $p['images'][] = $img;
            }
        }

        /* ------------------------------
           HANDLE VIDEO
        --------------------------------*/
        if ($video_path){
            if (!empty($p['video'])) delete_file_path($p['video']);
            $p['video'] = $video_path;
        }
    }

/* =====================================================
   ADD NEW PRODUCT
===================================================== */
} else {

    $nid = next_id($data['products']);

    // Jika tidak upload gambar sama sekali → pakai placeholder
    if (empty($uploadedImages)) {
        $uploadedImages = [
            'https://via.placeholder.com/800x600?text=' . urlencode($name)
        ];
    }

    $data['products'][] = [
        'id'          => $nid,
        'name'        => $name,
        'description' => $desc,
        'category_id' => $category_id,
        'images'      => $uploadedImages,
        'video'       => $video_path ?: '',
        'price'       => $price,
        'link'        => $link,
        'stock'       => $stock
    ];
}

/* ------------------------------
   SAVE DATA
--------------------------------*/
save_data($data);

header('Location: products.php');
exit;
?>